/*jslint devel: true, bitwise: true, regexp: true, browser: true, confusion: true, unparam: true, eqeq: true, white: true, nomen: true, plusplus: true, maxerr: 50, indent: 4 */
/*globals jQuery,Color */

/*!
 * ColorPicker
 *
 * Copyright (c) 2011-2013 Martijn W. van der Lee
 * Licensed under the MIT.
 */
/* Full-featured colorpicker for jQueryUI with full theming support.
 * Most images from jPicker by Christopher T. Tillman.
 * Sourcecode created from scratch by Martijn W. van der Lee.
 */
!function(a){"use strict";var b=0,c='<div class="ui-colorpicker ui-colorpicker-dialog ui-dialog ui-widget ui-widget-content ui-corner-all" style="display: none;"></div>',d='<div class="ui-colorpicker ui-colorpicker-inline ui-dialog ui-widget ui-widget-content ui-corner-all"></div>',e='<div class="ui-colorpicker ui-colorpicker-inline"></div>',f=function(a){var b=Math.floor(a).toString(16);return 1===b.length&&(b="0"+b),b.toLowerCase()},g=function(b){var c,d;return d=/^#?([a-fA-F0-9]{1,6})$/.exec(b),d?(c=parseInt(d[1],16),new a.colorpicker.Color((c>>16&255)/255,(c>>8&255)/255,(255&c)/255)):new a.colorpicker.Color},h=function(b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q;for(b.sort(function(a,b){return a.pos[1]===b.pos[1]?a.pos[0]-b.pos[0]:a.pos[1]-b.pos[1]}),g=0,h=0,a.each(b,function(a,b){g=Math.max(g,b.pos[0]+b.pos[2]),h=Math.max(h,b.pos[1]+b.pos[3])}),d=[],e=0;e<g;++e)d.push([]);for(j=[],i=[],a.each(b,function(a,b){for(e=0;e<b.pos[2];e+=1)i[b.pos[0]+e]=!0;for(f=0;f<b.pos[3];f+=1)j[b.pos[1]+f]=!0}),m="",l=b[k=0],f=0;f<h;++f){for(m+="<tr>",e=0;e<g;)if("undefined"!=typeof l&&e===l.pos[0]&&f===l.pos[1]){for(m+=c(l,e,f),o=0;o<l.pos[3];o+=1)for(n=0;n<l.pos[2];n+=1)d[e+n][f+o]=!0;e+=l.pos[2],l=b[++k]}else{for(p=0,q=!1;e<g&&void 0===d[e][f]&&(void 0===l||f<l.pos[1]||f===l.pos[1]&&e<l.pos[0]);)i[e]===!0&&(p+=1),q=!0,e+=1;p>0?m+='<td colspan="'+p+'"></td>':q||(e+=1)}m+="</tr>"}return'<table cellspacing="0" cellpadding="0" border="0"><tbody>'+m+"</tbody></table>"};a.colorpicker=new function(){this.regional={"":{ok:"OK",cancel:"Cancel",none:"None",button:"Color",title:"Pick a color",transparent:"Transparent",hsvH:"H",hsvS:"S",hsvV:"V",rgbR:"R",rgbG:"G",rgbB:"B",labL:"L",labA:"a",labB:"b",hslH:"H",hslS:"S",hslL:"L",cmykC:"C",cmykM:"M",cmykY:"Y",cmykK:"K",alphaA:"A"}},this.swatches={html:[{name:"black",r:0,g:0,b:0},{name:"dimgray",r:.4117647058823529,g:.4117647058823529,b:.4117647058823529},{name:"gray",r:.5019607843137255,g:.5019607843137255,b:.5019607843137255},{name:"darkgray",r:.6627450980392157,g:.6627450980392157,b:.6627450980392157},{name:"silver",r:.7529411764705882,g:.7529411764705882,b:.7529411764705882},{name:"lightgrey",r:.8274509803921568,g:.8274509803921568,b:.8274509803921568},{name:"gainsboro",r:.8627450980392157,g:.8627450980392157,b:.8627450980392157},{name:"whitesmoke",r:.9607843137254902,g:.9607843137254902,b:.9607843137254902},{name:"white",r:1,g:1,b:1},{name:"rosybrown",r:.7372549019607844,g:.5607843137254902,b:.5607843137254902},{name:"indianred",r:.803921568627451,g:.3607843137254902,b:.3607843137254902},{name:"brown",r:.6470588235294118,g:.16470588235294117,b:.16470588235294117},{name:"firebrick",r:.6980392156862745,g:.13333333333333333,b:.13333333333333333},{name:"lightcoral",r:.9411764705882353,g:.5019607843137255,b:.5019607843137255},{name:"maroon",r:.5019607843137255,g:0,b:0},{name:"darkred",r:.5450980392156862,g:0,b:0},{name:"red",r:1,g:0,b:0},{name:"snow",r:1,g:.9803921568627451,b:.9803921568627451},{name:"salmon",r:.9803921568627451,g:.5019607843137255,b:.4470588235294118},{name:"mistyrose",r:1,g:.8941176470588236,b:.8823529411764706},{name:"tomato",r:1,g:.38823529411764707,b:.2784313725490196},{name:"darksalmon",r:.9137254901960784,g:.5882352941176471,b:.47843137254901963},{name:"orangered",r:1,g:.27058823529411763,b:0},{name:"coral",r:1,g:.4980392156862745,b:.3137254901960784},{name:"lightsalmon",r:1,g:.6274509803921569,b:.47843137254901963},{name:"sienna",r:.6274509803921569,g:.3215686274509804,b:.17647058823529413},{name:"seashell",r:1,g:.9607843137254902,b:.9333333333333333},{name:"chocolate",r:.8235294117647058,g:.4117647058823529,b:.11764705882352941},{name:"saddlebrown",r:.5450980392156862,g:.27058823529411763,b:.07450980392156863},{name:"sandybrown",r:.9568627450980393,g:.6431372549019608,b:.3764705882352941},{name:"peachpuff",r:1,g:.8549019607843137,b:.7254901960784313},{name:"peru",r:.803921568627451,g:.5215686274509804,b:.24705882352941178},{name:"linen",r:.9803921568627451,g:.9411764705882353,b:.9019607843137255},{name:"darkorange",r:1,g:.5490196078431373,b:0},{name:"bisque",r:1,g:.8941176470588236,b:.7686274509803922},{name:"burlywood",r:.8705882352941177,g:.7215686274509804,b:.5294117647058824},{name:"tan",r:.8235294117647058,g:.7058823529411765,b:.5490196078431373},{name:"antiquewhite",r:.9803921568627451,g:.9215686274509803,b:.8431372549019608},{name:"navajowhite",r:1,g:.8705882352941177,b:.6784313725490196},{name:"blanchedalmond",r:1,g:.9215686274509803,b:.803921568627451},{name:"papayawhip",r:1,g:.9372549019607843,b:.8352941176470589},{name:"orange",r:1,g:.6470588235294118,b:0},{name:"moccasin",r:1,g:.8941176470588236,b:.7098039215686275},{name:"wheat",r:.9607843137254902,g:.8705882352941177,b:.7019607843137254},{name:"oldlace",r:.9921568627450981,g:.9607843137254902,b:.9019607843137255},{name:"floralwhite",r:1,g:.9803921568627451,b:.9411764705882353},{name:"goldenrod",r:.8549019607843137,g:.6470588235294118,b:.12549019607843137},{name:"darkgoldenrod",r:.7215686274509804,g:.5254901960784314,b:.043137254901960784},{name:"cornsilk",r:1,g:.9725490196078431,b:.8627450980392157},{name:"gold",r:1,g:.8431372549019608,b:0},{name:"palegoldenrod",r:.9333333333333333,g:.9098039215686274,b:.6666666666666666},{name:"khaki",r:.9411764705882353,g:.9019607843137255,b:.5490196078431373},{name:"lemonchiffon",r:1,g:.9803921568627451,b:.803921568627451},{name:"darkkhaki",r:.7411764705882353,g:.7176470588235294,b:.4196078431372549},{name:"beige",r:.9607843137254902,g:.9607843137254902,b:.8627450980392157},{name:"lightgoldenrodyellow",r:.9803921568627451,g:.9803921568627451,b:.8235294117647058},{name:"olive",r:.5019607843137255,g:.5019607843137255,b:0},{name:"yellow",r:1,g:1,b:0},{name:"lightyellow",r:1,g:1,b:.8784313725490196},{name:"ivory",r:1,g:1,b:.9411764705882353},{name:"olivedrab",r:.4196078431372549,g:.5568627450980392,b:.13725490196078433},{name:"yellowgreen",r:.6039215686274509,g:.803921568627451,b:.19607843137254902},{name:"darkolivegreen",r:.3333333333333333,g:.4196078431372549,b:.1843137254901961},{name:"greenyellow",r:.6784313725490196,g:1,b:.1843137254901961},{name:"lawngreen",r:.48627450980392156,g:.9882352941176471,b:0},{name:"chartreuse",r:.4980392156862745,g:1,b:0},{name:"darkseagreen",r:.5607843137254902,g:.7372549019607844,b:.5607843137254902},{name:"forestgreen",r:.13333333333333333,g:.5450980392156862,b:.13333333333333333},{name:"limegreen",r:.19607843137254902,g:.803921568627451,b:.19607843137254902},{name:"lightgreen",r:.5647058823529412,g:.9333333333333333,b:.5647058823529412},{name:"palegreen",r:.596078431372549,g:.984313725490196,b:.596078431372549},{name:"darkgreen",r:0,g:.39215686274509803,b:0},{name:"green",r:0,g:.5019607843137255,b:0},{name:"lime",r:0,g:1,b:0},{name:"honeydew",r:.9411764705882353,g:1,b:.9411764705882353},{name:"mediumseagreen",r:.23529411764705882,g:.7019607843137254,b:.44313725490196076},{name:"seagreen",r:.1803921568627451,g:.5450980392156862,b:.3411764705882353},{name:"springgreen",r:0,g:1,b:.4980392156862745},{name:"mintcream",r:.9607843137254902,g:1,b:.9803921568627451},{name:"mediumspringgreen",r:0,g:.9803921568627451,b:.6039215686274509},{name:"mediumaquamarine",r:.4,g:.803921568627451,b:.6666666666666666},{name:"aquamarine",r:.4980392156862745,g:1,b:.8313725490196079},{name:"turquoise",r:.25098039215686274,g:.8784313725490196,b:.8156862745098039},{name:"lightseagreen",r:.12549019607843137,g:.6980392156862745,b:.6666666666666666},{name:"mediumturquoise",r:.2823529411764706,g:.8196078431372549,b:.8},{name:"darkslategray",r:.1843137254901961,g:.30980392156862746,b:.30980392156862746},{name:"paleturquoise",r:.6862745098039216,g:.9333333333333333,b:.9333333333333333},{name:"teal",r:0,g:.5019607843137255,b:.5019607843137255},{name:"darkcyan",r:0,g:.5450980392156862,b:.5450980392156862},{name:"darkturquoise",r:0,g:.807843137254902,b:.8196078431372549},{name:"aqua",r:0,g:1,b:1},{name:"cyan",r:0,g:1,b:1},{name:"lightcyan",r:.8784313725490196,g:1,b:1},{name:"azure",r:.9411764705882353,g:1,b:1},{name:"cadetblue",r:.37254901960784315,g:.6196078431372549,b:.6274509803921569},{name:"powderblue",r:.6901960784313725,g:.8784313725490196,b:.9019607843137255},{name:"lightblue",r:.6784313725490196,g:.8470588235294118,b:.9019607843137255},{name:"deepskyblue",r:0,g:.7490196078431373,b:1},{name:"skyblue",r:.5294117647058824,g:.807843137254902,b:.9215686274509803},{name:"lightskyblue",r:.5294117647058824,g:.807843137254902,b:.9803921568627451},{name:"steelblue",r:.27450980392156865,g:.5098039215686274,b:.7058823529411765},{name:"aliceblue",r:.9411764705882353,g:.9725490196078431,b:1},{name:"dodgerblue",r:.11764705882352941,g:.5647058823529412,b:1},{name:"slategray",r:.4392156862745098,g:.5019607843137255,b:.5647058823529412},{name:"lightslategray",r:.4666666666666667,g:.5333333333333333,b:.6},{name:"lightsteelblue",r:.6901960784313725,g:.7686274509803922,b:.8705882352941177},{name:"cornflowerblue",r:.39215686274509803,g:.5843137254901961,b:.9294117647058824},{name:"royalblue",r:.2549019607843137,g:.4117647058823529,b:.8823529411764706},{name:"midnightblue",r:.09803921568627451,g:.09803921568627451,b:.4392156862745098},{name:"lavender",r:.9019607843137255,g:.9019607843137255,b:.9803921568627451},{name:"navy",r:0,g:0,b:.5019607843137255},{name:"darkblue",r:0,g:0,b:.5450980392156862},{name:"mediumblue",r:0,g:0,b:.803921568627451},{name:"blue",r:0,g:0,b:1},{name:"ghostwhite",r:.9725490196078431,g:.9725490196078431,b:1},{name:"darkslateblue",r:.2823529411764706,g:.23921568627450981,b:.5450980392156862},{name:"slateblue",r:.41568627450980394,g:.35294117647058826,b:.803921568627451},{name:"mediumslateblue",r:.4823529411764706,g:.40784313725490196,b:.9333333333333333},{name:"mediumpurple",r:.5764705882352941,g:.4392156862745098,b:.8588235294117647},{name:"blueviolet",r:.5411764705882353,g:.16862745098039217,b:.8862745098039215},{name:"indigo",r:.29411764705882354,g:0,b:.5098039215686274},{name:"darkorchid",r:.6,g:.19607843137254902,b:.8},{name:"darkviolet",r:.5803921568627451,g:0,b:.8274509803921568},{name:"mediumorchid",r:.7294117647058823,g:.3333333333333333,b:.8274509803921568},{name:"thistle",r:.8470588235294118,g:.7490196078431373,b:.8470588235294118},{name:"plum",r:.8666666666666667,g:.6274509803921569,b:.8666666666666667},{name:"violet",r:.9333333333333333,g:.5098039215686274,b:.9333333333333333},{name:"purple",r:.5019607843137255,g:0,b:.5019607843137255},{name:"darkmagenta",r:.5450980392156862,g:0,b:.5450980392156862},{name:"magenta",r:1,g:0,b:1},{name:"fuchsia",r:1,g:0,b:1},{name:"orchid",r:.8549019607843137,g:.4392156862745098,b:.8392156862745098},{name:"mediumvioletred",r:.7803921568627451,g:.08235294117647059,b:.5215686274509804},{name:"deeppink",r:1,g:.0784313725490196,b:.5764705882352941},{name:"hotpink",r:1,g:.4117647058823529,b:.7058823529411765},{name:"palevioletred",r:.8588235294117647,g:.4392156862745098,b:.5764705882352941},{name:"lavenderblush",r:1,g:.9411764705882353,b:.9607843137254902},{name:"crimson",r:.8627450980392157,g:.0784313725490196,b:.23529411764705882},{name:"pink",r:1,g:.7529411764705882,b:.796078431372549},{name:"lightpink",r:1,g:.7137254901960784,b:.7568627450980392}]},this.writers={"#HEX":function(a,b){return b._formatColor("#rxgxbx",a)},"#HEX3":function(b,c){var d=a.colorpicker.writers.HEX3(b);return d!==!1&&"#"+d},HEX:function(a,b){return b._formatColor("rxgxbx",a)},HEX3:function(a,b){var c=a.getRGB(),d=Math.floor(255*c.r),e=Math.floor(255*c.g),f=Math.floor(255*c.b);return d>>>4===(d&=15)&&e>>>4===(e&=15)&&f>>>4===(f&=15)&&d.toString(16)+e.toString(16)+f.toString(16)},RGB:function(a,b){return a.getAlpha()>=1&&b._formatColor("rgb(rd,gd,bd)",a)},RGBA:function(a,b){return b._formatColor("rgba(rd,gd,bd,af)",a)},"RGB%":function(a,b){return a.getAlpha()>=1&&b._formatColor("rgb(rp%,gp%,bp%)",a)},"RGBA%":function(a,b){return b._formatColor("rgba(rp%,gp%,bp%,af)",a)},HSL:function(a,b){return a.getAlpha()>=1&&b._formatColor("hsl(hd,sd,vd)",a)},HSLA:function(a,b){return b._formatColor("hsla(hd,sd,vd,af)",a)},"HSL%":function(a,b){return a.getAlpha()>=1&&b._formatColor("hsl(hp%,sp%,vp%)",a)},"HSLA%":function(a,b){return b._formatColor("hsla(hp%,sp%,vp%,af)",a)},NAME:function(a,b){return b._closestName(a)},EXACT:function(a,b){return b._exactName(a)}},this.parsers={"":function(b){if(""===b)return new a.colorpicker.Color},NAME:function(b,c){var d=c._getSwatch(a.trim(b));if(d)return new a.colorpicker.Color(d.r,d.g,d.b)},RGBA:function(b){var c=/^rgba?\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*(?:,\s*(\d+(?:\.\d+)?)\s*)?\)$/.exec(b);if(c)return new a.colorpicker.Color(c[1]/255,c[2]/255,c[3]/255,parseFloat(c[4]))},"RGBA%":function(b){var c=/^rgba?\(\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d+(?:\.\d+)?)\s*)?\)$/.exec(b);if(c)return new a.colorpicker.Color(c[1]/100,c[2]/100,c[3]/100,c[4]/100)},HSLA:function(b){var c=/^hsla?\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*(?:,\s*(\d+(?:\.\d+)?)\s*)?\)$/.exec(b);if(c)return(new a.colorpicker.Color).setHSL(c[1]/255,c[2]/255,c[3]/255).setAlpha(parseFloat(c[4]))},"HSLA%":function(b){var c=/^hsla?\(\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d+(?:\.\d+)?)\s*)?\)$/.exec(b);if(c)return(new a.colorpicker.Color).setHSL(c[1]/100,c[2]/100,c[3]/100).setAlpha(c[4]/100)},"#HEX":function(b){var c=/^#([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})$/.exec(b);if(c)return new a.colorpicker.Color(parseInt(c[1],16)/255,parseInt(c[2],16)/255,parseInt(c[3],16)/255)},"#HEX3":function(b){var c=/^#([a-fA-F0-9])([a-fA-F0-9])([a-fA-F0-9])$/.exec(b);if(c)return new a.colorpicker.Color(parseInt(String(c[1])+c[1],16)/255,parseInt(String(c[2])+c[2],16)/255,parseInt(String(c[3])+c[3],16)/255)},HEX:function(b){var c=/^([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})$/.exec(b);if(c)return new a.colorpicker.Color(parseInt(c[1],16)/255,parseInt(c[2],16)/255,parseInt(c[3],16)/255)},HEX3:function(b){var c=/^([a-fA-F0-9])([a-fA-F0-9])([a-fA-F0-9])$/.exec(b);if(c)return new a.colorpicker.Color(parseInt(String(c[1])+c[1],16)/255,parseInt(String(c[2])+c[2],16)/255,parseInt(String(c[3])+c[3],16)/255)}},this.partslists={full:["header","map","bar","hex","hsv","rgb","alpha","lab","cmyk","preview","swatches","footer"],popup:["map","bar","hex","hsv","rgb","alpha","preview","footer"],draggable:["header","map","bar","hex","hsv","rgb","alpha","preview","footer"],inline:["map","bar","hex","hsv","rgb","alpha","preview"]},this.limits={websafe:function(a){a.limit(6)},nibble:function(a){a.limit(16)},binary:function(a){a.limit(2)},name:function(a,b){var c=b._getSwatch(b._closestName(a));a.setRGB(c.r,c.g,c.b)}},this.parts={header:function(b){var d=null,e=function(){var a=b.options.title||b._getRegional("title"),c='<span class="ui-dialog-title">'+a+"</span>";return!b.inline&&b.options.showCloseButton&&(c+='<a href="#" class="ui-dialog-titlebar-close ui-corner-all" role="button"><span class="ui-icon ui-icon-closethick">close</span></a>'),'<div class="ui-dialog-titlebar ui-widget-header ui-corner-all ui-helper-clearfix">'+c+"</div>"};this.init=function(){d=a(e()).prependTo(b.dialog);var c=a(".ui-dialog-titlebar-close",d);if(b._hoverable(c),b._focusable(c),c.click(function(a){a.preventDefault(),b.close(b.options.revert)}),!b.inline&&b.options.draggable){var f={handle:d};b.options.containment&&(f.containment=b.options.containment),b.dialog.draggable(f)}}},map:function(b){var f,g,h,i,c=this,d=null;f=function(c){if(b.opened){var e=a(".ui-colorpicker-map-layer-pointer",d),i=e.offset(),j=e.width(),k=e.height(),l=c.pageX-i.left,m=c.pageY-i.top;l>=0&&l<j&&m>=0&&m<k&&(c.stopImmediatePropagation(),c.preventDefault(),d.unbind("mousedown",f),a(document).bind("mouseup",g),a(document).bind("mousemove",h),h(c))}},g=function(b){b.stopImmediatePropagation(),b.preventDefault(),a(document).unbind("mouseup",g),a(document).unbind("mousemove",h),d.bind("mousedown",f)},h=function(e){if(e.stopImmediatePropagation(),e.preventDefault(),e.pageX!==c.x||e.pageY!==c.y){c.x=e.pageX,c.y=e.pageY;var f=a(".ui-colorpicker-map-layer-pointer",d),g=f.offset(),h=f.width(),i=f.height(),j=e.pageX-g.left,k=e.pageY-g.top;switch(j=Math.max(0,Math.min(j/h,1)),k=Math.max(0,Math.min(k/i,1)),b.mode){case"h":b.color.setHSV(null,j,1-k);break;case"s":case"a":b.color.setHSV(j,null,1-k);break;case"v":b.color.setHSV(j,1-k,null);break;case"r":b.color.setRGB(null,1-k,j);break;case"g":b.color.setRGB(1-k,null,j);break;case"b":b.color.setRGB(j,1-k,null)}b._change()}},i=function(){var a='<div class="ui-colorpicker-map ui-colorpicker-map-'+(b.options.part.map.size||256)+' ui-colorpicker-border"><span class="ui-colorpicker-map-layer-1">&nbsp;</span><span class="ui-colorpicker-map-layer-2">&nbsp;</span>'+(b.options.alpha?'<span class="ui-colorpicker-map-layer-alpha">&nbsp;</span>':"")+'<span class="ui-colorpicker-map-layer-pointer"><span class="ui-colorpicker-map-pointer"></span></span></div>';return a},this.update=function(){var e=65*(b.options.part.map.size||256)/64;switch(b.mode){case"h":a(".ui-colorpicker-map-layer-1",d).css({"background-position":"0 0",opacity:""}).show(),a(".ui-colorpicker-map-layer-2",d).hide();break;case"s":case"a":a(".ui-colorpicker-map-layer-1",d).css({"background-position":"0 "+-e+"px",opacity:""}).show(),a(".ui-colorpicker-map-layer-2",d).css({"background-position":"0 "+2*-e+"px",opacity:""}).show();break;case"v":a(d).css("background-color","black"),a(".ui-colorpicker-map-layer-1",d).css({"background-position":"0 "+3*-e+"px",opacity:""}).show(),a(".ui-colorpicker-map-layer-2",d).hide();break;case"r":a(".ui-colorpicker-map-layer-1",d).css({"background-position":"0 "+4*-e+"px",opacity:""}).show(),a(".ui-colorpicker-map-layer-2",d).css({"background-position":"0 "+5*-e+"px",opacity:""}).show();break;case"g":a(".ui-colorpicker-map-layer-1",d).css({"background-position":"0 "+6*-e+"px",opacity:""}).show(),a(".ui-colorpicker-map-layer-2",d).css({"background-position":"0 "+7*-e+"px",opacity:""}).show();break;case"b":a(".ui-colorpicker-map-layer-1",d).css({"background-position":"0 "+8*-e+"px",opacity:""}).show(),a(".ui-colorpicker-map-layer-2",d).css({"background-position":"0 "+9*-e+"px",opacity:""}).show()}c.repaint()},this.repaint=function(){var c=a(".ui-colorpicker-map-layer-pointer",d),e=0,f=0;switch(b.mode){case"h":e=b.color.getHSV().s*c.width(),f=(1-b.color.getHSV().v)*c.width(),a(d).css("background-color",b.color.copy().setHSV(null,1,1).toCSS());break;case"s":case"a":e=b.color.getHSV().h*c.width(),f=(1-b.color.getHSV().v)*c.width(),a(".ui-colorpicker-map-layer-2",d).css("opacity",1-b.color.getHSV().s);break;case"v":e=b.color.getHSV().h*c.width(),f=(1-b.color.getHSV().s)*c.width(),a(".ui-colorpicker-map-layer-1",d).css("opacity",b.color.getHSV().v);break;case"r":e=b.color.getRGB().b*c.width(),f=(1-b.color.getRGB().g)*c.width(),a(".ui-colorpicker-map-layer-2",d).css("opacity",b.color.getRGB().r);break;case"g":e=b.color.getRGB().b*c.width(),f=(1-b.color.getRGB().r)*c.width(),a(".ui-colorpicker-map-layer-2",d).css("opacity",b.color.getRGB().g);break;case"b":e=b.color.getRGB().r*c.width(),f=(1-b.color.getRGB().g)*c.width(),a(".ui-colorpicker-map-layer-2",d).css("opacity",b.color.getRGB().b)}b.options.alpha&&a(".ui-colorpicker-map-layer-alpha",d).css("opacity",1-b.color.getAlpha()),a(".ui-colorpicker-map-pointer",d).css({left:e-7,top:f-7})},this.init=function(){d=a(i()).appendTo(a(".ui-colorpicker-map-container",b.dialog)),d.bind("mousedown",f)}},bar:function(b){var e,f,g,h,c=this,d=null;e=function(c){if(b.opened){var h=a(".ui-colorpicker-bar-layer-pointer",d),i=h.offset(),j=h.width(),k=h.height(),l=c.pageX-i.left,m=c.pageY-i.top;l>=0&&l<j&&m>=0&&m<k&&(c.stopImmediatePropagation(),c.preventDefault(),d.unbind("mousedown",e),a(document).bind("mouseup",f),a(document).bind("mousemove",g),g(c))}},f=function(b){b.stopImmediatePropagation(),b.preventDefault(),a(document).unbind("mouseup",f),a(document).unbind("mousemove",g),d.bind("mousedown",e)},g=function(e){if(e.stopImmediatePropagation(),e.preventDefault(),e.pageY!==c.y){c.y=e.pageY;var f=a(".ui-colorpicker-bar-layer-pointer",d),g=f.offset(),h=f.height(),i=e.pageY-g.top;switch(i=Math.max(0,Math.min(i/h,1)),b.mode){case"h":b.color.setHSV(1-i,null,null);break;case"s":b.color.setHSV(null,1-i,null);break;case"v":b.color.setHSV(null,null,1-i);break;case"r":b.color.setRGB(1-i,null,null);break;case"g":b.color.setRGB(null,1-i,null);break;case"b":b.color.setRGB(null,null,1-i);break;case"a":b.color.setAlpha(1-i)}b._change()}},h=function(){var a='<div class="ui-colorpicker-bar ui-colorpicker-bar-'+(b.options.part.bar.size||256)+'  ui-colorpicker-border"><span class="ui-colorpicker-bar-layer-1">&nbsp;</span><span class="ui-colorpicker-bar-layer-2">&nbsp;</span><span class="ui-colorpicker-bar-layer-3">&nbsp;</span><span class="ui-colorpicker-bar-layer-4">&nbsp;</span>';return b.options.alpha&&(a+='<span class="ui-colorpicker-bar-layer-alpha">&nbsp;</span><span class="ui-colorpicker-bar-layer-alphabar">&nbsp;</span>'),a+='<span class="ui-colorpicker-bar-layer-pointer"><span class="ui-colorpicker-bar-pointer"></span></span></div>'},this.update=function(){var e=65*(b.options.part.bar.size||256)/64;switch(b.mode){case"h":case"s":case"v":case"r":case"g":case"b":a(".ui-colorpicker-bar-layer-alpha",d).show(),a(".ui-colorpicker-bar-layer-alphabar",d).hide();break;case"a":a(".ui-colorpicker-bar-layer-alpha",d).hide(),a(".ui-colorpicker-bar-layer-alphabar",d).show()}switch(b.mode){case"h":a(".ui-colorpicker-bar-layer-1",d).css({"background-position":"0 0",opacity:""}).show(),a(".ui-colorpicker-bar-layer-2",d).hide(),a(".ui-colorpicker-bar-layer-3",d).hide(),a(".ui-colorpicker-bar-layer-4",d).hide();break;case"s":a(".ui-colorpicker-bar-layer-1",d).css({"background-position":"0 "+-e+"px",opacity:""}).show(),a(".ui-colorpicker-bar-layer-2",d).css({"background-position":"0 "+2*-e+"px",opacity:""}).show(),a(".ui-colorpicker-bar-layer-3",d).hide(),a(".ui-colorpicker-bar-layer-4",d).hide();break;case"v":a(".ui-colorpicker-bar-layer-1",d).css({"background-position":"0 "+2*-e+"px",opacity:""}).show(),a(".ui-colorpicker-bar-layer-2",d).hide(),a(".ui-colorpicker-bar-layer-3",d).hide(),a(".ui-colorpicker-bar-layer-4",d).hide();break;case"r":a(".ui-colorpicker-bar-layer-1",d).css({"background-position":"0 "+6*-e+"px",opacity:""}).show(),a(".ui-colorpicker-bar-layer-2",d).css({"background-position":"0 "+5*-e+"px",opacity:""}).show(),a(".ui-colorpicker-bar-layer-3",d).css({"background-position":"0 "+3*-e+"px",opacity:""}).show(),a(".ui-colorpicker-bar-layer-4",d).css({"background-position":"0 "+4*-e+"px",opacity:""}).show();break;case"g":a(".ui-colorpicker-bar-layer-1",d).css({"background-position":"0 "+10*-e+"px",opacity:""}).show(),a(".ui-colorpicker-bar-layer-2",d).css({"background-position":"0 "+9*-e+"px",opacity:""}).show(),a(".ui-colorpicker-bar-layer-3",d).css({"background-position":"0 "+7*-e+"px",opacity:""}).show(),a(".ui-colorpicker-bar-layer-4",d).css({"background-position":"0 "+8*-e+"px",opacity:""}).show();break;case"b":a(".ui-colorpicker-bar-layer-1",d).css({"background-position":"0 "+14*-e+"px",opacity:""}).show(),a(".ui-colorpicker-bar-layer-2",d).css({"background-position":"0 "+13*-e+"px",opacity:""}).show(),a(".ui-colorpicker-bar-layer-3",d).css({"background-position":"0 "+11*-e+"px",opacity:""}).show(),a(".ui-colorpicker-bar-layer-4",d).css({"background-position":"0 "+12*-e+"px",opacity:""}).show();break;case"a":a(".ui-colorpicker-bar-layer-1",d).hide(),a(".ui-colorpicker-bar-layer-2",d).hide(),a(".ui-colorpicker-bar-layer-3",d).hide(),a(".ui-colorpicker-bar-layer-4",d).hide()}c.repaint()},this.repaint=function(){var c=a(".ui-colorpicker-bar-layer-pointer",d),e=0;switch(b.mode){case"h":e=(1-b.color.getHSV().h)*c.height();break;case"s":e=(1-b.color.getHSV().s)*c.height(),a(".ui-colorpicker-bar-layer-2",d).css("opacity",1-b.color.getHSV().v),a(d).css("background-color",b.color.copy().setHSV(null,1,null).toCSS());break;case"v":e=(1-b.color.getHSV().v)*c.height(),a(d).css("background-color",b.color.copy().setHSV(null,null,1).toCSS());break;case"r":e=(1-b.color.getRGB().r)*c.height(),a(".ui-colorpicker-bar-layer-2",d).css("opacity",Math.max(0,b.color.getRGB().b-b.color.getRGB().g)),a(".ui-colorpicker-bar-layer-3",d).css("opacity",Math.max(0,b.color.getRGB().g-b.color.getRGB().b)),a(".ui-colorpicker-bar-layer-4",d).css("opacity",Math.min(b.color.getRGB().b,b.color.getRGB().g));break;case"g":e=(1-b.color.getRGB().g)*c.height(),a(".ui-colorpicker-bar-layer-2",d).css("opacity",Math.max(0,b.color.getRGB().b-b.color.getRGB().r)),a(".ui-colorpicker-bar-layer-3",d).css("opacity",Math.max(0,b.color.getRGB().r-b.color.getRGB().b)),a(".ui-colorpicker-bar-layer-4",d).css("opacity",Math.min(b.color.getRGB().r,b.color.getRGB().b));break;case"b":e=(1-b.color.getRGB().b)*c.height(),a(".ui-colorpicker-bar-layer-2",d).css("opacity",Math.max(0,b.color.getRGB().r-b.color.getRGB().g)),a(".ui-colorpicker-bar-layer-3",d).css("opacity",Math.max(0,b.color.getRGB().g-b.color.getRGB().r)),a(".ui-colorpicker-bar-layer-4",d).css("opacity",Math.min(b.color.getRGB().r,b.color.getRGB().g));break;case"a":e=(1-b.color.getAlpha())*c.height(),a(d).css("background-color",b.color.copy().toCSS())}"a"!==b.mode&&a(".ui-colorpicker-bar-layer-alpha",d).css("opacity",1-b.color.getAlpha()),a(".ui-colorpicker-bar-pointer",d).css("top",e-3)},this.init=function(){d=a(h()).appendTo(a(".ui-colorpicker-bar-container",b.dialog)),d.bind("mousedown",e)}},preview:function(b){var e,d=null;e=function(){return'<div class="ui-colorpicker-preview ui-colorpicker-border"><div class="ui-colorpicker-preview-initial"><div class="ui-colorpicker-preview-initial-alpha"></div></div><div class="ui-colorpicker-preview-current"><div class="ui-colorpicker-preview-current-alpha"></div></div></div>'},this.init=function(){d=a(e()).appendTo(a(".ui-colorpicker-preview-container",b.dialog)),a(".ui-colorpicker-preview-initial",d).click(function(){b.color=b.currentColor.copy(),b._change()})},this.update=function(){b.options.alpha?a(".ui-colorpicker-preview-initial-alpha, .ui-colorpicker-preview-current-alpha",d).show():a(".ui-colorpicker-preview-initial-alpha, .ui-colorpicker-preview-current-alpha",d).hide(),this.repaint()},this.repaint=function(){a(".ui-colorpicker-preview-initial",d).css("background-color",b.currentColor.set?b.currentColor.toCSS():"").attr("title",b.currentColor.set?b.currentColor.toCSS():""),a(".ui-colorpicker-preview-initial-alpha",d).css("opacity",1-b.currentColor.getAlpha()),a(".ui-colorpicker-preview-current",d).css("background-color",b.color.set?b.color.toCSS():"").attr("title",b.color.set?b.color.toCSS():""),a(".ui-colorpicker-preview-current-alpha",d).css("opacity",1-b.color.getAlpha())}},hsv:function(b){var e,d=null;e=function(){var a="";return b.options.hsv&&(a+='<div class="ui-colorpicker-hsv-h"><input class="ui-colorpicker-mode" type="radio" value="h"/><label>'+b._getRegional("hsvH")+'</label><input class="ui-colorpicker-number" type="number" min="0" max="360" size="10"/><span class="ui-colorpicker-unit">&deg;</span></div><div class="ui-colorpicker-hsv-s"><input class="ui-colorpicker-mode" type="radio" value="s"/><label>'+b._getRegional("hsvS")+'</label><input class="ui-colorpicker-number" type="number" min="0" max="100" size="10"/><span class="ui-colorpicker-unit">%</span></div><div class="ui-colorpicker-hsv-v"><input class="ui-colorpicker-mode" type="radio" value="v"/><label>'+b._getRegional("hsvV")+'</label><input class="ui-colorpicker-number" type="number" min="0" max="100" size="10"/><span class="ui-colorpicker-unit">%</span></div>'),'<div class="ui-colorpicker-hsv">'+a+"</div>"},this.init=function(){d=a(e()).appendTo(a(".ui-colorpicker-hsv-container",b.dialog)),a(".ui-colorpicker-mode",d).click(function(){b.mode=a(this).val(),b._updateAllParts()}),a(".ui-colorpicker-number",d).bind("change keyup",function(){b.color.setHSV(a(".ui-colorpicker-hsv-h .ui-colorpicker-number",d).val()/360,a(".ui-colorpicker-hsv-s .ui-colorpicker-number",d).val()/100,a(".ui-colorpicker-hsv-v .ui-colorpicker-number",d).val()/100),b._change()})},this.repaint=function(){var c=b.color.getHSV();c.h*=360,c.s*=100,c.v*=100,a.each(c,function(b,c){var e=a(".ui-colorpicker-hsv-"+b+" .ui-colorpicker-number",d);c=Math.round(c),parseInt(e.val(),10)!==c&&e.val(c)})},this.update=function(){a(".ui-colorpicker-mode",d).each(function(){a(this).attr("checked",a(this).val()===b.mode)}),this.repaint()}},rgb:function(b){var e,d=null;e=function(){var a="";return b.options.rgb&&(a+='<div class="ui-colorpicker-rgb-r"><input class="ui-colorpicker-mode" type="radio" value="r"/><label>'+b._getRegional("rgbR")+'</label><input class="ui-colorpicker-number" type="number" min="0" max="255"/></div><div class="ui-colorpicker-rgb-g"><input class="ui-colorpicker-mode" type="radio" value="g"/><label>'+b._getRegional("rgbG")+'</label><input class="ui-colorpicker-number" type="number" min="0" max="255"/></div><div class="ui-colorpicker-rgb-b"><input class="ui-colorpicker-mode" type="radio" value="b"/><label>'+b._getRegional("rgbB")+'</label><input class="ui-colorpicker-number" type="number" min="0" max="255"/></div>'),'<div class="ui-colorpicker-rgb">'+a+"</div>"},this.init=function(){d=a(e()).appendTo(a(".ui-colorpicker-rgb-container",b.dialog)),a(".ui-colorpicker-mode",d).click(function(){b.mode=a(this).val(),b._updateAllParts()}),a(".ui-colorpicker-number",d).bind("change keyup",function(){a(".ui-colorpicker-rgb-r .ui-colorpicker-number",d).val();b.color.setRGB(a(".ui-colorpicker-rgb-r .ui-colorpicker-number",d).val()/255,a(".ui-colorpicker-rgb-g .ui-colorpicker-number",d).val()/255,a(".ui-colorpicker-rgb-b .ui-colorpicker-number",d).val()/255),b._change()})},this.repaint=function(){a.each(b.color.getRGB(),function(b,c){var e=a(".ui-colorpicker-rgb-"+b+" .ui-colorpicker-number",d);c=Math.floor(255*c),parseInt(e.val(),10)!==c&&e.val(c)})},this.update=function(){a(".ui-colorpicker-mode",d).each(function(){a(this).attr("checked",a(this).val()===b.mode)}),this.repaint()}},lab:function(b){var d=null,e=function(){var a="";return b.options.hsv&&(a+='<div class="ui-colorpicker-lab-l"><label>'+b._getRegional("labL")+'</label><input class="ui-colorpicker-number" type="number" min="0" max="100"/></div><div class="ui-colorpicker-lab-a"><label>'+b._getRegional("labA")+'</label><input class="ui-colorpicker-number" type="number" min="-128" max="127"/></div><div class="ui-colorpicker-lab-b"><label>'+b._getRegional("labB")+'</label><input class="ui-colorpicker-number" type="number" min="-128" max="127"/></div>'),'<div class="ui-colorpicker-lab">'+a+"</div>"};this.init=function(){d=a(e()).appendTo(a(".ui-colorpicker-lab-container",b.dialog)),a(".ui-colorpicker-number",d).bind("change keyup",function(c){b.color.setLAB(parseInt(a(".ui-colorpicker-lab-l .ui-colorpicker-number",d).val(),10)/100,(parseInt(a(".ui-colorpicker-lab-a .ui-colorpicker-number",d).val(),10)+128)/255,(parseInt(a(".ui-colorpicker-lab-b .ui-colorpicker-number",d).val(),10)+128)/255),b._change()})},this.repaint=function(){var c=b.color.getLAB();c.l*=100,c.a=255*c.a-128,c.b=255*c.b-128,a.each(c,function(b,c){var e=a(".ui-colorpicker-lab-"+b+" .ui-colorpicker-number",d);c=Math.round(c),parseInt(e.val(),10)!==c&&e.val(c)})},this.update=function(){this.repaint()}},cmyk:function(b){var d=null,e=function(){var a="";return b.options.hsv&&(a+='<div class="ui-colorpicker-cmyk-c"><label>'+b._getRegional("cmykC")+'</label><input class="ui-colorpicker-number" type="number" min="0" max="100"/><span class="ui-colorpicker-unit">%</span></div><div class="ui-colorpicker-cmyk-m"><label>'+b._getRegional("cmykM")+'</label><input class="ui-colorpicker-number" type="number" min="0" max="100"/><span class="ui-colorpicker-unit">%</span></div><div class="ui-colorpicker-cmyk-y"><label>'+b._getRegional("cmykY")+'</label><input class="ui-colorpicker-number" type="number" min="0" max="100"/><span class="ui-colorpicker-unit">%</span></div><div class="ui-colorpicker-cmyk-k"><label>'+b._getRegional("cmykK")+'</label><input class="ui-colorpicker-number" type="number" min="0" max="100"/><span class="ui-colorpicker-unit">%</span></div>'),
'<div class="ui-colorpicker-cmyk">'+a+"</div>"};this.init=function(){d=a(e()).appendTo(a(".ui-colorpicker-cmyk-container",b.dialog)),a(".ui-colorpicker-number",d).bind("change keyup",function(c){b.color.setCMYK(parseInt(a(".ui-colorpicker-cmyk-c .ui-colorpicker-number",d).val(),10)/100,parseInt(a(".ui-colorpicker-cmyk-m .ui-colorpicker-number",d).val(),10)/100,parseInt(a(".ui-colorpicker-cmyk-y .ui-colorpicker-number",d).val(),10)/100,parseInt(a(".ui-colorpicker-cmyk-k .ui-colorpicker-number",d).val(),10)/100),b._change()})},this.repaint=function(){a.each(b.color.getCMYK(),function(b,c){var e=a(".ui-colorpicker-cmyk-"+b+" .ui-colorpicker-number",d);c=Math.round(100*c),parseInt(e.val(),10,10)!==c&&e.val(c)})},this.update=function(){this.repaint()}},alpha:function(b){var e,d=null;e=function(){var a="";return b.options.alpha&&(a+='<div class="ui-colorpicker-a"><input class="ui-colorpicker-mode" name="mode" type="radio" value="a"/><label>'+b._getRegional("alphaA")+'</label><input class="ui-colorpicker-number" type="number" min="0" max="100"/><span class="ui-colorpicker-unit">%</span></div>'),'<div class="ui-colorpicker-alpha">'+a+"</div>"},this.init=function(){d=a(e()).appendTo(a(".ui-colorpicker-alpha-container",b.dialog)),a(".ui-colorpicker-mode",d).click(function(){b.mode=a(this).val(),b._updateAllParts()}),a(".ui-colorpicker-number",d).bind("change keyup",function(){b.color.setAlpha(a(".ui-colorpicker-a .ui-colorpicker-number",d).val()/100),b._change()})},this.update=function(){a(".ui-colorpicker-mode",d).each(function(){a(this).attr("checked",a(this).val()===b.mode)}),this.repaint()},this.repaint=function(){var c=a(".ui-colorpicker-a .ui-colorpicker-number",d),e=Math.round(100*b.color.getAlpha());parseInt(c.val(),10)!==e&&c.val(e)}},hex:function(b){var e,d=null;e=function(){var a="";return b.options.alpha&&(a+='<input class="ui-colorpicker-hex-alpha" type="text" maxlength="2" size="2"/>'),a+='<input class="ui-colorpicker-hex-input" type="text" maxlength="6" size="6"/>','<div class="ui-colorpicker-hex"><label>#</label>'+a+"</div>"},this.init=function(){d=a(e()).appendTo(a(".ui-colorpicker-hex-container",b.dialog)),a(".ui-colorpicker-hex-input",d).bind("change keydown keyup",function(b,c,d){/[^a-fA-F0-9]/.test(a(this).val())&&a(this).val(a(this).val().replace(/[^a-fA-F0-9]/,""))}),a(".ui-colorpicker-hex-input",d).bind("change keyup",function(){b.color=g(a(this).val()).setAlpha(b.color.getAlpha()),b._change()}),a(".ui-colorpicker-hex-alpha",d).bind("change keydown keyup",function(){/[^a-fA-F0-9]/.test(a(this).val())&&a(this).val(a(this).val().replace(/[^a-fA-F0-9]/,""))}),a(".ui-colorpicker-hex-alpha",d).bind("change keyup",function(){b.color.setAlpha(parseInt(a(".ui-colorpicker-hex-alpha",d).val(),16)/255),b._change()})},this.update=function(){this.repaint()},this.repaint=function(){a(".ui-colorpicker-hex-input",d).is(":focus")||a(".ui-colorpicker-hex-input",d).val(b.color.toHex(!0)),a(".ui-colorpicker-hex-alpha",d).is(":focus")||a(".ui-colorpicker-hex-alpha",d).val(f(255*b.color.getAlpha()))}},swatches:function(b){var d=null,e=function(){var c="";return b._eachSwatch(function(b,d){var e=new a.colorpicker.Color(d.r,d.g,d.b),f=e.toCSS();c+='<div class="ui-colorpicker-swatch" style="background-color:'+f+'" title="'+b+'"></div>'}),'<div class="ui-colorpicker-swatches ui-colorpicker-border" style="width:'+b.options.swatchesWidth+'px">'+c+"</div>"};this.init=function(){d=a(e()).appendTo(a(".ui-colorpicker-swatches-container",b.dialog)),a(".ui-colorpicker-swatch",d).click(function(){b.color=b._parseColor(a(this).css("background-color")),b._change()})}},footer:function(c){var e=null,f="ui-colorpicker-special-transparent-"+b,g="ui-colorpicker-special-none-"+b,h=function(){var a="";return(c.options.alpha||!c.inline&&c.options.showNoneButton)&&(a+='<div class="ui-colorpicker-buttonset">',c.options.alpha&&(a+='<input type="radio" name="ui-colorpicker-special" id="'+f+'" class="ui-colorpicker-special-transparent"/><label for="'+f+'">'+c._getRegional("transparent")+"</label>"),!c.inline&&c.options.showNoneButton&&(a+='<input type="radio" name="ui-colorpicker-special" id="'+g+'" class="ui-colorpicker-special-none"><label for="'+g+'">'+c._getRegional("none")+"</label>"),a+="</div>"),c.inline||(a+='<div class="ui-dialog-buttonset">',c.options.showCancelButton&&(a+='<button class="ui-colorpicker-cancel">'+c._getRegional("cancel")+"</button>"),a+='<button class="ui-colorpicker-ok">'+c._getRegional("ok")+"</button>",a+="</div>"),'<div class="ui-dialog-buttonpane ui-widget-content">'+a+"</div>"};this.init=function(){e=a(h()).appendTo(c.dialog),a(".ui-colorpicker-ok",e).button().click(function(){c.close()}),a(".ui-colorpicker-cancel",e).button().click(function(){c.close(!0)}),a(".ui-colorpicker-buttonset",e).buttonset(),a(".ui-colorpicker-special-color",e).click(function(){c._change()}),a("#"+g,e).click(function(){c.color.set=!1,c._change()}),a("#"+f,e).click(function(){c.color.setAlpha(0),c._change()})},this.repaint=function(){c.color.set?0===c.color.getAlpha()?a(".ui-colorpicker-special-transparent",e).attr("checked",!0).button("refresh"):a("input",e).attr("checked",!1).button("refresh"):a(".ui-colorpicker-special-none",e).attr("checked",!0).button("refresh"),a(".ui-colorpicker-cancel",e).button(c.changed?"enable":"disable")},this.update=function(){}}},this.Color=function(){var b={rgb:{r:0,g:0,b:0},hsv:{h:0,s:0,v:0},hsl:{h:0,s:0,l:0},lab:{l:0,a:0,b:0},cmyk:{c:0,m:0,y:0,k:1}},c=1,d=[.9504285,1,1.0889],e=arguments,f=function(a){return isNaN(a)||null===a?0:("string"==typeof a&&(a=parseInt(a,10)),Math.max(0,Math.min(a,1)))},g=function(a){var b="0123456789abcdef",c=a%16,d=(a-c)/16,e=b.charAt(d)+b.charAt(c);return e},h=function(a){var b=a.r>.04045?Math.pow((a.r+.055)/1.055,2.4):a.r/12.92,c=a.g>.04045?Math.pow((a.g+.055)/1.055,2.4):a.g/12.92,d=a.b>.04045?Math.pow((a.b+.055)/1.055,2.4):a.b/12.92;return{x:.4124*b+.3576*c+.1805*d,y:.2126*b+.7152*c+.0722*d,z:.0193*b+.1192*c+.9505*d}},i=function(a){var b={r:3.2406*a.x+a.y*-1.5372+a.z*-.4986,g:a.x*-.9689+1.8758*a.y+.0415*a.z,b:.0557*a.x+a.y*-.204+1.057*a.z};return b.r=b.r>.0031308?1.055*Math.pow(b.r,1/2.4)-.055:12.92*b.r,b.g=b.g>.0031308?1.055*Math.pow(b.g,1/2.4)-.055:12.92*b.g,b.b=b.b>.0031308?1.055*Math.pow(b.b,1/2.4)-.055:12.92*b.b,b},j=function(a){var e,f,g,b=Math.min(a.r,a.g,a.b),c=Math.max(a.r,a.g,a.b),d=c-b,h={h:0,s:0,v:c};return 0===d?(h.h=0,h.s=0):(h.s=d/c,e=((c-a.r)/6+d/2)/d,f=((c-a.g)/6+d/2)/d,g=((c-a.b)/6+d/2)/d,a.r===c?h.h=g-f:a.g===c?h.h=1/3+e-g:a.b===c&&(h.h=2/3+f-e),h.h<0?h.h+=1:h.h>1&&(h.h-=1)),h},k=function(a){var c,d,e,f,g,b={r:0,g:0,b:0};return 0===a.s?b.r=b.g=b.b=a.v:(c=1===a.h?0:6*a.h,d=Math.floor(c),e=a.v*(1-a.s),f=a.v*(1-a.s*(c-d)),g=a.v*(1-a.s*(1-(c-d))),0===d?(b.r=a.v,b.g=g,b.b=e):1===d?(b.r=f,b.g=a.v,b.b=e):2===d?(b.r=e,b.g=a.v,b.b=g):3===d?(b.r=e,b.g=f,b.b=a.v):4===d?(b.r=g,b.g=e,b.b=a.v):(b.r=a.v,b.g=e,b.b=f)),b},l=function(a){var e,f,g,b=Math.min(a.r,a.g,a.b),c=Math.max(a.r,a.g,a.b),d=c-b,h={h:0,s:0,l:(c+b)/2};return 0===d?(h.h=0,h.s=0):(h.s=h.l<.5?d/(c+b):d/(2-c-b),e=((c-a.r)/6+d/2)/d,f=((c-a.g)/6+d/2)/d,g=((c-a.b)/6+d/2)/d,a.r===c?h.h=g-f:a.g===c?h.h=1/3+e-g:a.b===c&&(h.h=2/3+f-e),h.h<0?h.h+=1:h.h>1&&(h.h-=1)),h},m=function(a){var b,c,d=function(a,b,c){return c<0&&(c+=1),c>1&&(c-=1),6*c<1?a+6*(b-a)*c:2*c<1?b:3*c<2?a+(b-a)*(2/3-c)*6:a};return 0===a.s?{r:a.l,g:a.l,b:a.l}:(c=a.l<.5?a.l*(1+a.s):a.l+a.s-a.s*a.l,b=2*a.l-c,{r:d(b,c,a.h+1/3),g:d(b,c,a.h),b:d(b,c,a.h-1/3)})},n=function(a){var b=a.x/d[0],c=a.y/d[1],e=a.z/d[2];return b=b>.008856?Math.pow(b,1/3):7.787*b+16/116,c=c>.008856?Math.pow(c,1/3):7.787*c+16/116,e=e>.008856?Math.pow(e,1/3):7.787*e+16/116,{l:(116*c-16)/100,a:(500*(b-c)+128)/255,b:(200*(c-e)+128)/255}},o=function(a){var b={l:100*a.l,a:255*a.a-128,b:255*a.b-128},c={x:0,y:(b.l+16)/116,z:0};return c.x=b.a/500+c.y,c.z=c.y-b.b/200,c.x=Math.pow(c.x,3)>.008856?Math.pow(c.x,3):(c.x-16/116)/7.787,c.y=Math.pow(c.y,3)>.008856?Math.pow(c.y,3):(c.y-16/116)/7.787,c.z=Math.pow(c.z,3)>.008856?Math.pow(c.z,3):(c.z-16/116)/7.787,c.x*=d[0],c.y*=d[1],c.z*=d[2],c},p=function(a){return{c:1-a.r,m:1-a.g,y:1-a.b}},q=function(a){return{r:1-a.c,g:1-a.m,b:1-a.y}},r=function(a){var b=1;return a.c<b&&(b=a.c),a.m<b&&(b=a.m),a.y<b&&(b=a.y),1===b?{c:0,m:0,y:0,k:1}:{c:(a.c-b)/(1-b),m:(a.m-b)/(1-b),y:(a.y-b)/(1-b),k:b}},s=function(a){return{c:a.c*(1-a.k)+a.k,m:a.m*(1-a.k)+a.k,y:a.y*(1-a.k)+a.k}};this.set=!1,this.setAlpha=function(a){return null!==a&&(c=f(a)),this.set=!0,this},this.getAlpha=function(){return c},this.setRGB=function(a,c,d){return b={rgb:this.getRGB()},null!==a&&(b.rgb.r=f(a)),null!==c&&(b.rgb.g=f(c)),null!==d&&(b.rgb.b=f(d)),this.set=!0,this},this.setHSV=function(a,c,d){return b={hsv:this.getHSV()},null!==a&&(b.hsv.h=f(a)),null!==c&&(b.hsv.s=f(c)),null!==d&&(b.hsv.v=f(d)),this.set=!0,this},this.setHSL=function(a,c,d){return b={hsl:this.getHSL()},null!==a&&(b.hsl.h=f(a)),null!==c&&(b.hsl.s=f(c)),null!==d&&(b.hsl.l=f(d)),this.set=!0,this},this.setLAB=function(a,c,d){return b={lab:this.getLAB()},null!==a&&(b.lab.l=f(a)),null!==c&&(b.lab.a=f(c)),null!==d&&(b.lab.b=f(d)),this.set=!0,this},this.setCMYK=function(a,c,d,e){return b={cmyk:this.getCMYK()},null!==a&&(b.cmyk.c=f(a)),null!==c&&(b.cmyk.m=f(c)),null!==d&&(b.cmyk.y=f(d)),null!==e&&(b.cmyk.k=f(e)),this.set=!0,this},this.getRGB=function(){return b.rgb||(b.rgb=b.lab?i(o(b.lab)):b.hsv?k(b.hsv):b.hsl?m(b.hsl):b.cmyk?q(s(b.cmyk)):{r:0,g:0,b:0},b.rgb.r=f(b.rgb.r),b.rgb.g=f(b.rgb.g),b.rgb.b=f(b.rgb.b)),a.extend({},b.rgb)},this.getHSV=function(){return b.hsv||(b.hsv=b.lab?j(this.getRGB()):b.rgb?j(b.rgb):b.hsl?j(this.getRGB()):b.cmyk?j(this.getRGB()):{h:0,s:0,v:0},b.hsv.h=f(b.hsv.h),b.hsv.s=f(b.hsv.s),b.hsv.v=f(b.hsv.v)),a.extend({},b.hsv)},this.getHSL=function(){return b.hsl||(b.hsl=b.rgb?l(b.rgb):b.hsv?l(this.getRGB()):b.cmyk?l(this.getRGB()):b.hsv?l(this.getRGB()):{h:0,s:0,l:0},b.hsl.h=f(b.hsl.h),b.hsl.s=f(b.hsl.s),b.hsl.l=f(b.hsl.l)),a.extend({},b.hsl)},this.getCMYK=function(){return b.cmyk||(b.cmyk=b.rgb?r(p(b.rgb)):b.hsv?r(p(this.getRGB())):b.hsl?r(p(this.getRGB())):b.lab?r(p(this.getRGB())):{c:0,m:0,y:0,k:1},b.cmyk.c=f(b.cmyk.c),b.cmyk.m=f(b.cmyk.m),b.cmyk.y=f(b.cmyk.y),b.cmyk.k=f(b.cmyk.k)),a.extend({},b.cmyk)},this.getLAB=function(){return b.lab||(b.lab=b.rgb?n(h(b.rgb)):b.hsv?n(h(this.getRGB())):b.hsl?n(h(this.getRGB())):b.cmyk?n(h(this.getRGB())):{l:0,a:0,b:0},b.lab.l=f(b.lab.l),b.lab.a=f(b.lab.a),b.lab.b=f(b.lab.b)),a.extend({},b.lab)},this.getChannels=function(){return{r:this.getRGB().r,g:this.getRGB().g,b:this.getRGB().b,a:this.getAlpha(),h:this.getHSV().h,s:this.getHSV().s,v:this.getHSV().v,c:this.getCMYK().c,m:this.getCMYK().m,y:this.getCMYK().y,k:this.getCMYK().k,L:this.getLAB().l,A:this.getLAB().a,B:this.getLAB().b}},this.getSpaces=function(){return a.extend(!0,{},b)},this.distance=function(a){var g,b="lab",c="get"+b.toUpperCase(),d=this[c](),e=a[c](),f=0;for(g in d)f+=Math.pow(d[g]-e[g],2);return f},this.equals=function(a){var b=this.getRGB(),c=a.getRGB();return this.getAlpha()===a.getAlpha()&&b.r===c.r&&b.g===c.g&&b.b===c.b},this.limit=function(a){a-=1;var b=this.getRGB();this.setRGB(Math.round(b.r*a)/a,Math.round(b.g*a)/a,Math.round(b.b*a)/a)},this.toHex=function(){var a=this.getRGB();return g(255*a.r)+g(255*a.g)+g(255*a.b)},this.toCSS=function(){return"#"+this.toHex()},this.copy=function(){var b=new a.colorpicker.Color(this.getSpaces(),this.getAlpha());return b.set=this.set,b},2===e.length&&(b=e[0],this.setAlpha(0===e[1]?0:e[1]||1),this.set=!0),e.length>2&&(this.setRGB(e[0],e[1],e[2]),this.setAlpha(0===e[3]?0:e[3]||1),this.set=!0)}},a.widget("vanderlee.colorpicker",{options:{alpha:!1,altAlpha:!0,altField:"",altOnChange:!0,altProperties:"background-color",autoOpen:!1,buttonClass:null,buttonColorize:!1,buttonImage:"assets/css/colorpicker/ui-colorpicker.png",buttonImageOnly:!1,buttonText:null,closeOnEscape:!0,closeOnOutside:!0,color:"#00FF00",colorFormat:"HEX",draggable:!0,containment:null,duration:"fast",hsv:!0,inline:!0,inlineFrame:!0,layout:{map:[0,0,1,5],bar:[1,0,1,5],preview:[2,0,1,1],hsv:[2,1,1,1],rgb:[2,2,1,1],alpha:[2,3,1,1],hex:[2,4,1,1],lab:[3,1,1,1],cmyk:[3,2,1,2],swatches:[4,0,1,5]},limit:"",modal:!1,mode:"h",okOnEnter:!1,parts:"",part:{map:{size:256},bar:{size:256}},regional:"",revert:!1,rgb:!0,showAnim:"fadeIn",showCancelButton:!0,showNoneButton:!1,showCloseButton:!0,showOn:"focus click alt",showOptions:{},swatches:null,swatchesWidth:84,title:null,cancel:null,close:null,init:null,select:null,ok:null,open:null},_create:function(){var d,c=this;return++b,c.widgetEventPrefix="colorpicker",c.opened=!1,c.generated=!1,c.inline=!1,c.changed=!1,c.dialog=null,c.button=null,c.image=null,c.overlay=null,c.mode=c.options.mode,c.element.is("input")||c.options.inline===!1?(c._setColor(c.element.is("input")?c.element.val():c.options.color),c._callback("init"),/\bfocus|both\b/.test(c.options.showOn)&&c.element.bind("focus",function(){c.open()}),/\bclick|both\b/.test(c.options.showOn)&&c.element.bind("click",function(){c.open()}),/\bbutton|both\b/.test(c.options.showOn)&&(""!==c.options.buttonImage&&(d=c.options.buttonText||c._getRegional("button"),c.image=a("<img/>").attr({src:c.options.buttonImage,alt:d,title:d}),c.options.buttonClass&&c.image.attr("class",c.options.buttonClass),c._setImageBackground()),c.options.buttonImageOnly&&c.image?c.button=c.image:(c.button=a('<button type="button"></button>').html(c.image||c.options.buttonText).button(),c.image=c.image?a("img",c.button).first():null),c.button.insertAfter(c.element).click(function(){c[c.opened?"close":"open"]()})),/\balt|both\b/.test(c.options.showOn)&&a(c.options.altField).bind("click",function(){c.open()}),c.options.autoOpen&&c.open()):(c.inline=!0,c._generate(),c.opened=!0),this},_setOption:function(b,c){var d=this;switch(b){case"disabled":c?d.dialog.addClass("ui-colorpicker-disabled"):d.dialog.removeClass("ui-colorpicker-disabled")}a.Widget.prototype._setOption.apply(d,arguments)},_setImageBackground:function(){this.image&&this.options.buttonColorize&&this.image.css("background-color",this.color.set?this._formatColor("RGBA",this.color):"")},_setAltField:function(){if(this.options.altOnChange&&this.options.altField&&this.options.altProperties){var b,c,d=this.options.altProperties.split(",");for(b=0;b<=d.length;++b)switch(c=a.trim(d[b])){case"color":case"fill":case"stroke":case"background-color":case"backgroundColor":case"outline-color":case"border-color":a(this.options.altField).css(c,this.color.set?this.color.toCSS():"")}this.options.altAlpha&&a(this.options.altField).css("opacity",this.color.set?this.color.getAlpha():"")}},_setColor:function(a){this.color=this._parseColor(a),this.currentColor=this.color.copy(),this._setImageBackground(),this._setAltField()},setColor:function(a){this._setColor(a),this._change()},getColor:function(a){return this._formatColor(a||this.options.colorFormat,this.color)},_generateInline:function(){var b=this;a(b.element).html(b.options.inlineFrame?d:e),b.dialog=a(".ui-colorpicker",b.element)},_generatePopup:function(){var b=this;a("body").append(c),b.dialog=a(".ui-colorpicker:last"),a(document).delegate("html","touchstart click",function(c){if(b.opened&&c.target!==b.element[0]&&!b.overlay){if(b.dialog.is(c.target)||b.dialog.has(c.target).length>0)return void b.element.blur();var d,e=a(c.target).parents();for(e.push(c.target),d=0;d<=e.length;++d){if(null!==b.button&&e[d]===b.button[0])return;if(/\balt|both\b/.test(b.options.showOn)&&a(b.options.altField).is(e[d]))return}b.options.closeOnOutside&&b.close(b.options.revert)}}),a(document).keydown(function(a){b.opened&&27===a.keyCode&&b.options.closeOnEscape&&b.close(b.options.revert),b.opened&&13===a.keyCode&&b.options.okOnEnter&&b.close()}),b.element.keydown(function(a){9===a.keyCode&&b.close()}).keyup(function(a){var c=b._parseColor(b.element.val());b.color.equals(c)||(b.color=c,b._change())})},_generate:function(){var e,f,g,i,b=this;b._setColor(b.inline||!b.element.is("input")?b.options.color:b.element.val()),b[b.inline?"_generateInline":"_generatePopup"](),e="string"==typeof b.options.parts?a.colorpicker.partslists[b.options.parts]?a.colorpicker.partslists[b.options.parts]:a.colorpicker.partslists[b.inline?"inline":"popup"]:b.options.parts,b.parts={},a.each(e,function(c,d){a.colorpicker.parts[d]&&(b.parts[d]=new a.colorpicker.parts[d](b))}),b.generated||(f=[],a.each(b.options.layout,function(a,c){b.parts[a]&&f.push({part:a,pos:c})}),g=a(h(f,function(a,b,c){return i=["ui-colorpicker-"+a.part+"-container"],b>0&&i.push("ui-colorpicker-padding-left"),c>0&&i.push("ui-colorpicker-padding-top"),'<td  class="'+i.join(" ")+'"'+(a.pos[2]>1?' colspan="'+a.pos[2]+'"':"")+(a.pos[3]>1?' rowspan="'+a.pos[3]+'"':"")+' valign="top"></td>'})).appendTo(b.dialog),b.options.inlineFrame&&g.addClass("ui-dialog-content ui-widget-content"),b._initAllParts(),b._updateAllParts(),b.generated=!0)},_effectGeneric:function(b,c,d,e,f){var g=this;a.effects&&a.effects[g.options.showAnim]?b[c](g.options.showAnim,g.options.showOptions,g.options.duration,f):(b["slideDown"===g.options.showAnim?d:"fadeIn"===g.options.showAnim?e:c](g.options.showAnim?g.options.duration:null,f),g.options.showAnim&&g.options.duration||f())},_effectShow:function(a,b){this._effectGeneric(a,"show","slideDown","fadeIn",b)},_effectHide:function(a,b){this._effectGeneric(a,"hide","slideUp","fadeOut",b)},open:function(){var c,d,e,f,g,h,i,j,k,b=this;if(!b.opened){if(b._generate(),b.element.is(":hidden")?(k=a("<div/>").insertBefore(b.element),c=k.offset(),k.remove()):c=b.element.offset(),d=a(window).height()+a(window).scrollTop(),e=a(window).width()+a(window).scrollLeft(),f=b.dialog.outerHeight(!1),g=b.dialog.outerWidth(),h=c.left,i=c.top+b.element.outerHeight(!1),h+g>e&&(h=Math.max(0,e-g)),i+f>d&&(i=c.top-f>=a(window).scrollTop()?c.top-f:Math.max(0,d-f)),b.dialog.css({left:h,top:i}),j=0,a(b.element[0]).parents().each(function(){var b=a(this).css("z-index");if("number"!=typeof b&&"string"!=typeof b||""===b||isNaN(b))a(this).siblings().each(function(){var b=a(this).css("z-index");"number"!=typeof b&&"string"!=typeof b||""===b||isNaN(b)||b>j&&(j=parseInt(b,10))});else if(b>j)return j=parseInt(b,10),!1}),b.dialog.css("z-index",j+=2),b.overlay=b.options.modal?new a.ui.dialog.overlay(b):null,null!==b.overlay){var l=b.overlay.$el.css("z-index");"number"!=typeof l&&"string"!=typeof l||""===l||isNaN(l)||b.dialog.css("z-index",j+l+2)}b._effectShow(this.dialog),b.opened=!0,b._callback("open",!0),a(function(){b._repaintAllParts()})}},close:function(a){var b=this;a?(b.color=b.currentColor.copy(),b._change(),b._callback("cancel",!0)):(b.currentColor=b.color.copy(),b._callback("ok",!0)),b.changed=!1,b._effectHide(b.dialog,function(){b.dialog.remove(),b.dialog=null,b.generated=!1,b.opened=!1,b._callback("close",!0)}),b.overlay&&b.overlay.destroy()},destroy:function(){this.element.unbind(),null!==this.image&&this.image.remove(),null!==this.button&&this.button.remove(),null!==this.dialog&&this.dialog.remove(),this.overlay&&this.overlay.destroy()},_callback:function(a,b){var d,e,c=this;return c.color.set?(d={formatted:c._formatColor(c.options.colorFormat,c.color),colorPicker:c},e=c.color.getLAB(),e.a=2*e.a-1,e.b=2*e.b-1,b===!0&&(d.a=c.color.getAlpha(),d.rgb=c.color.getRGB(),d.hsv=c.color.getHSV(),d.cmyk=c.color.getCMYK(),d.hsl=c.color.getHSL(),d.lab=e),c._trigger(a,null,d)):c._trigger(a,null,{formatted:"",colorPicker:c})},_initAllParts:function(){a.each(this.parts,function(a,b){b.init&&b.init()})},_updateAllParts:function(){a.each(this.parts,function(a,b){b.update&&b.update()})},_repaintAllParts:function(){a.each(this.parts,function(a,b){b.repaint&&b.repaint()})},_change:function(){this.changed=!0,this.options.limit&&a.colorpicker.limits[this.options.limit]&&a.colorpicker.limits[this.options.limit](this.color,this),this.inline||(this.color.set?this.color.equals(this._parseColor(this.element.val()))||this.element.val(this._formatColor(this.options.colorFormat,this.color)):this.element.val(""),this._setImageBackground(),this._setAltField()),this.options.color=this.color.set?this.color.toCSS():"",this.opened&&this._repaintAllParts(),this._callback("select")},_hoverable:function(a){a.hover(function(){a.addClass("ui-state-hover")},function(){a.removeClass("ui-state-hover")})},_focusable:function(a){a.focus(function(){a.addClass("ui-state-focus")}).blur(function(){a.removeClass("ui-state-focus")})},_getRegional:function(b){return void 0!==a.colorpicker.regional[this.options.regional][b]?a.colorpicker.regional[this.options.regional][b]:a.colorpicker.regional[""][b]},_getSwatches:function(){return"string"==typeof this.options.swatches?a.colorpicker.swatches[this.options.swatches]:a.isPlainObject(this.options.swatches)?this.colorpicker.swatches:a.colorpicker.swatches.html},_eachSwatch:function(b){var d,c=this._getSwatches();a.each(c,function(e,f){d=a.isArray(c)?f.name:e,b(d,f)})},_getSwatch:function(a){var b=!1;return this._eachSwatch(function(c,d){return c.toLowerCase()!=a.toLowerCase()||(b=d,!1)}),b},_parseColor:function(b){var d,c=this;return a.each(a.colorpicker.parsers,function(a,e){if(d=e(b,c))return!1}),d?d:new a.colorpicker.Color},_exactName:function(b){var c=!1;return this._eachSwatch(function(d,e){return!b.equals(new a.colorpicker.Color(e.r,e.g,e.b))||(c=d,!1)}),c},_closestName:function(b){var f,d=(b.getRGB(),null),e=!1;return this._eachSwatch(function(c,g){if(f=b.distance(new a.colorpicker.Color(g.r,g.g,g.b)),f<d||null===d){if(e=c,0===f)return!1;d=f}return!0}),e},_formatColor:function(b,c){var d=this,e=null,g={x:function(a){return f(255*a)},d:function(a){return Math.floor(255*a)},f:function(a){return a},p:function(a){return 100*a}},h=c.getChannels();return a.isArray(b)||(b=[b]),a.each(b,function(b,f){return a.colorpicker.writers[f]?(e=a.colorpicker.writers[f](c,d),e===!1):(e=f.replace(/\\?[argbhsvcmykLAB][xdfp]/g,function(a){return a.match(/^\\/)?a.slice(1):g[a.charAt(1)](h[a.charAt(0)])}),!1)}),e}})}(jQuery);